% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus-analysis.R
\name{runConsensusAnalysis}
\alias{runConsensusAnalysis}
\title{Perform Consensus Analysis}
\usage{
runConsensusAnalysis(
  PAResults,
  method = c("weightedZMean", "RRA"),
  weightsList = NULL,
  useFDR = TRUE,
  rank.by = c("normalizedScore", "pFDR", "both"),
  backgroundSpace = NULL
)
}
\arguments{
\item{PAResults}{A list of at least length two from enrichment analysis results.}

\item{method}{The consensus analsyis method. This can be either weighted.mean or RRA.}

\item{weightsList}{A vector of integer values.
Each element shows the corresponding input result weight.
When selected method is weighted.mean this parameter needs to be specified.
If it is null all the weights are considered as equal.}

\item{useFDR}{A logical parameter, indicating if adjusted p-values should be used.}

\item{rank.by}{An string parameter which specifies how the input results should be ranked.
This parameter is used when the selected method is RRA.}

\item{backgroundSpace}{A list of lists with the same length as PAResults.
Each list contains underlying space (set of pathways) for each input dataframe in PAResults.
This parameter is optional.
NULL means all input dataframes share a common space.
So the union pathways of all input dataframes is taken into account.}
}
\value{
A dataframe of consensus analysis result, which contains the following columns:
\itemize{
\item{ID: The ID of pathway}
\item{p.value: The p-value of pathway}
\item{pFDR: The adjusted p-value using Benjamini-Hochberg method}
\item{name: The name of pathway}
\item{pathwaySize: The size of pathway}
}
}
\description{
This function performs consensus analysis using two methods.
These methods are weighted.mean and RRA.
}
\examples{
\donttest{

library(RCPA)

affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")

consensusPAResult <- RCPA::runConsensusAnalysis(
    list(affyFgseaResult, agilFgseaResult, RNASeqFgseaResult),
    method = "weightedZMean"
)

print(head(consensusPAResult))

}
}
