% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{wtd.mode}
\alias{wtd.mode}
\title{Find Mode of Variable with Option to Weight Observations}
\usage{
wtd.mode(x, w, data, ...)
}
\arguments{
\item{x}{A variable}

\item{w}{(Optional) Sampling weights of variable}

\item{data}{(Optional) A dataset}

\item{...}{(Optional) Additional arguments pass to descr::freq function}
}
\value{
Returns the modal value(s) of the variable, if mode exists
}
\description{
Takes in variable and finds mode, works with sampling weights. Makes use of the freq function, part of the descr package.
}
\examples{
   library(RCPA3)
   
   wtd.mode(x=nes$angry.about.things, w=nes$wt)
   wtd.mode(x=nes$angry.about.things)
   
   wtd.mode(x=nes$discrim.vs.men, w=nes$wt)
   wtd.mode(x=nes$discrim.vs.men)
}
\keyword{internal}
