% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformC.r
\name{transformC}
\alias{transformC}
\title{Returns new variables by transforming existing dataset variables (e.g. dummy variables, standardized variables, rank orders)}
\usage{
transformC(type, x, data, response, cutpoints, groups, confirm = TRUE, ...)
}
\arguments{
\item{type}{The type of transformation to be made to x. Options include:
\itemize{
\item "center"
\item "cut" use \code{cutpoints} or \code{groups} arguments to control cuts
\item "dummy" use response argument to identify values of x which should be coded 1 (all other non-missing responses will be coded 0)
\item "dummy.set"
\item "ln"
\item "log10"
\item "percent.rank"
\item "rank"
\item "whole"
\item "z"
}}

\item{x}{The variable to be transformed, a variable that already exists, should be in dataset$var form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x variable.}

\item{response}{(Optional) For \code{type="dummy"}, response is the value or vector of values to be coded 1.}

\item{cutpoints}{(Optional) For \code{type="cut"}, a vector of values to serve as lower bounds of ranked categories for transformed x variable.}

\item{groups}{(Optional) For \code{type="cut"}, the number of (approximately) same sized groups to create based on x values.}

\item{confirm}{(Optional) By default, \code{transformC} will ask you to confirm you want transformed variable returned (to prevent data loss). Set \code{confirm=FALSE} to bypass this check.}

\item{...}{(Optional) Additional arguments pass to \code{\link[Hmisc]{cut2}} (for \code{type="cut"}).}
}
\value{
A transformed version of x variable, a vector with the same length as x, unless \code{type="dummy.set"} in which case transformC returns a data.frame.
}
\description{
Given a variable x, the \code{transformC} function generates and returns a tranformed version of x. For example, \code{transformC} can take a variable x and return standardized x, or the log of x.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=kYyfvzonFCs}{Transforming Variables with RCPA3 Package's transformC Function} 22:40
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 3.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 55-64. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=3}{R Tutorials & Resources for Creating and Transforming Variables}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
  library(RCPA3)
  
  # don't use confirm=FALSE until you've tested the function call
  transformC("percent.rank", nes$ft.dem, confirm=FALSE)
  transformC("rank", nes$ft.dem, confirm=FALSE)
  transformC("whole", runif(min=0,max=100,n=20), confirm=FALSE)
}
