% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose-response-analysis.R
\name{growth.drBootSpline}
\alias{growth.drBootSpline}
\title{Perform a smooth spline fit on response vs. concentration data of a single sample}
\usage{
growth.drBootSpline(conc, test, drID = "undefined", control = growth.control())
}
\arguments{
\item{conc}{Vector of concentration values.}

\item{test}{Vector of response parameter values of the same length as \code{conc}.}

\item{drID}{(Character) The name of the analyzed sample.}

\item{control}{A \code{grofit.control} object created with \code{\link{growth.control}}, defining relevant fitting options.}
}
\value{
An object of class \code{drBootSpline} containing a distribution of growth parameters and
a \code{drFitSpline} object for each bootstrap sample. Use \code{\link{plot.drBootSpline}}
to visualize all bootstrapping splines as well as the distribution of EC50.
\item{raw.conc}{Raw data provided to the function as \code{conc}.}
\item{raw.test}{Raw data for the response parameter provided to the function as \code{test}.}
\item{drID}{(Character) Identifies the tested condition.}
\item{boot.conc}{Table of concentration values per column, resulting from each spline fit of the bootstrap.}
\item{boot.test}{Table of response values per column, resulting from each spline fit of the bootstrap.}
\item{boot.drSpline}{List containing all \code{drFitSpline} objects generated by the call of \code{\link{growth.drFitSpline}}.}
\item{ec50.boot}{Vector of estimated EC50 values from each bootstrap entry.}
\item{ec50y.boot}{Vector of estimated response at EC50 values from each bootstrap entry.}
\item{BootFlag}{(Logical) Indicates the success of the bootstrapping operation.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{growth.drBootSpline} resamples the values in a dataset with replacement and performs a spline fit for each bootstrap sample to determine the EC50.
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+rnorm(19)/50, 0)

TestRun <- growth.drBootSpline(conc, response, drID = 'test',
               control = growth.control(log.x.dr = TRUE, smooth.dr = 0.8,
                                        nboot.dr = 50))

print(summary(TestRun))
plot(TestRun, combine = TRUE)

}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07
}
\seealso{
Other dose-response analysis functions: 
\code{\link{flFit}()},
\code{\link{growth.drFitSpline}()},
\code{\link{growth.gcFit}()},
\code{\link{growth.workflow}()}
}
\concept{dose-response analysis functions}
