% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareQuartets.R
\name{CompareQuartets}
\alias{CompareQuartets}
\title{Compare quartet states by explicit enumeration}
\usage{
CompareQuartets(x, cf)
}
\arguments{
\item{x, cf}{List of quartet states, perhaps generated by \code{\link[=QuartetStates]{QuartetStates()}}.}
}
\value{
Returns an array of seven numeric elements, corresponding
\describe{
\item{N}{The total number of quartet \emph{statements} for two trees of \emph{n} leaves,
i.e. 2 \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} leaves.}
\item{s}{The number of quartets that are resolved identically in both trees.}
\item{d}{The number of quartets that are resolved differently in each tree.}
\item{r1}{The number of quartets that are resolved in tree 1, but not in tree 2.}
\item{r2}{The number of quartets that are resolved in tree 2, but not in tree 1.}
\item{u}{The number of quartets that are unresolved in both trees.}
}
}
\description{
\code{CompareQuartets()} uses explicit enumeration to compare two lists of
quartet states  \insertCite{Estabrook1985}{Quartet},
detailing how many are identical and how many are unresolved.
For most purposes, the faster function \code{\link[=QuartetStatus]{QuartetStatus()}} will be
preferable.
}
\examples{
  trees <- list(TreeTools::BalancedTree(6),
                TreeTools::PectinateTree(6))
  quartets <- QuartetStates(trees)
  CompareQuartets(quartets[[1]], quartets[[2]])

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=QuartetStatus]{QuartetStatus()}} generates the same output from a list of trees.
}

Other element-by-element comparisons: 
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareSplits}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{QuartetState}()},
\code{\link{SharedQuartetStatus}()},
\code{\link{SplitStatus}()}

Other quartet counting functions: 
\code{\link{AllQuartets}()},
\code{\link{CompareQuartetsMulti}()},
\code{\link{ResolvedQuartets}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
\concept{quartet counting functions}
