% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{asthma_patients_tbl_df}
\alias{asthma_patients_tbl_df}
\title{COPD and Asthma Patients}
\format{
A tibble with 300 observations and 7 variables:
\describe{
  \item{Patient_ID}{Unique patient identifier (numeric)}
  \item{Age}{Patient age in years (numeric)}
  \item{Gender}{Patient gender (character)}
  \item{Smoking_Status}{Current/Former/Never smoker status (character)}
  \item{Asthma_Diagnosis}{Specific asthma/COPD diagnosis (character)}
  \item{Medication}{Prescribed treatment regimen (character)}
  \item{Peak_Flow}{Peak expiratory flow rate (numeric)}
}
}
\source{
Data taken from Kaggle: https://www.kaggle.com/datasets/jatinthakur706/copd-asthma-patient-dataset
}
\usage{
data(asthma_patients_tbl_df)
}
\description{
This dataset, asthma_patients_tbl_df, is a tibble containing clinical information
about 300 asthma (COPD) patients tracked over 3 years, including demographics,
smoking status, diagnosis details, medications, and peak flow measurements.
}
\details{
The dataset name has been kept as 'asthma_patients_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PulmoDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
