% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{pair_similarity}
\alias{pair_similarity}
\title{Compute a matrix of cosine similarity/distance of word pairs.}
\usage{
pair_similarity(
  data,
  words = NULL,
  pattern = NULL,
  words1 = NULL,
  words2 = NULL,
  distance = FALSE
)
}
\arguments{
\item{data}{A \code{\link[=as_wordvec]{wordvec}} (data.table) or \code{\link[=as_embed]{embed}} (matrix), see \code{\link[=data_wordvec_load]{data_wordvec_load()}}.}

\item{words}{[Option 1] Character string(s).}

\item{pattern}{[Option 2] \link[stringr:str_subset]{Regular expression}. If \code{words} and \code{pattern} are not specified, all words in the data will be extracted.}

\item{words1, words2}{[Option 3] Two sets of words for only n1 * n2 word pairs. See examples.}

\item{distance}{Compute cosine distance instead? Defaults to \code{FALSE} (cosine similarity).}
}
\value{
A matrix of pairwise cosine similarity/distance.
}
\description{
Compute a matrix of cosine similarity/distance of word pairs.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}): \url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
pair_similarity(demodata, c("China", "Chinese"))

pair_similarity(demodata, pattern="^Chi")

pair_similarity(demodata,
                words1=c("China", "Chinese"),
                words2=c("Japan", "Japanese"))

}
\seealso{
\code{\link[=cosine_similarity]{cosine_similarity()}}

\code{\link[=plot_similarity]{plot_similarity()}}

\code{\link[=tab_similarity]{tab_similarity()}}

\code{\link[=most_similar]{most_similar()}}
}
