% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_XGBoost.R
\name{vis_XGBoost}
\alias{vis_XGBoost}
\title{Visualization of the power estimations from XGBoost}
\usage{
vis_XGBoost(x,view='2D',legend_name='Power',
xlab='avg_log2FC_abs',ylab='mean_pct')
}
\arguments{
\item{x}{The result dataframe from 'pred_XGboost'.}

\item{view}{determines plot 2D/3D view, default='2D'.}

\item{legend_name}{The name of legend, default='Power'.}

\item{xlab}{The name of xlab, default='avg_log2FC_abs'.}

\item{ylab}{The name of ylab, default='mean_pct'.}
}
\value{
A 2D/3D plot of the power results from XGBoost.
}
\description{
This function takes the result from 'pred_XGboost' and plots 2D/3D views of it,
}
\examples{
data(power_example)
# Fit the local power surface of avg_log2FC_abs between 1 and 2
avg_log2FC_abs_1_2<-dplyr::filter(power_example,avg_log2FC_abs>1 & avg_log2FC_abs<2)
# Fit the model
bst<-fit_XGBoost(power_example$power,avg_log2FC=power_example$avg_log2FC_abs,
avg_PCT=power_example$mean_pct,replicates=power_example$sample_size)
pred<-pred_XGBoost(bst,n.grid=30,xlim=c(0,1.5),ylim=c(0,0.1),replicates=3)
vis_XGBoost(pred,view='2D',legend_name='Power',xlab='avg_log2FC_abs',ylab='mean_pct')


}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
