% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{animal_types}
\alias{animal_types}
\title{Returns data on an animal type, or types available from the Petfinder API. This data includes the 
available type's coat names and colors, gender and other specific information relevant to the 
specified type(s). The animal type must be of 'dog', 'cat', 'rabbit', 'small-furry', 'horse', 'bird', 
'scales-fins-other', 'barnyard'.}
\usage{
animal_types(types = NULL)
}
\arguments{
\item{types}{Specifies the animal type or types to return. Can be a character vector representing a single animal type, or a 
vector or list of animal types if more than one type is desired. If not specified, all animal types are returned.}
}
\value{
List of returned JSON data for each specified animal type from the Petfinder API.
}
\description{
Returns data on an animal type, or types available from the Petfinder API. This data includes the 
available type's coat names and colors, gender and other specific information relevant to the 
specified type(s). The animal type must be of 'dog', 'cat', 'rabbit', 'small-furry', 'horse', 'bird', 
'scales-fins-other', 'barnyard'.
}
\examples{
\dontrun{
pf <- Petfinder(key=key, secret=secret) # Initialize Petfinder class
cat <- pf$animal_types(types='cat')
cat_dog <- pf$animal_types(types=c('cat', 'dog'))
all_types <- pf$animal_types()
}
}
