% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelMatchObject.R
\name{summary.PanelMatch}
\alias{summary.PanelMatch}
\title{Summarize information about a PanelMatch object and the matched sets contained within them.}
\usage{
\method{summary}{PanelMatch}(object, ...)
}
\arguments{
\item{object}{a \code{PanelMatch} object}

\item{...}{Not used}
}
\value{
A list of data frame(s) containing information about matched sets associated with the specified qoi. If the qoi is "att", "art", or "atc", then the returned list contains one data frame and the element is named for the specified qoi. If the qoi is "ate", then a list of two elements is returned, with one data frame corresponding to the "att" and the other to the "atc". The data frame contains summary information about the sizes of matched sets, along with information about the number of treated observations and the number of empty sets. Specifically, it contains the minimum, 1st quartile, median, mean, 3rd quartile, and maximum matched set size. It also contains the number of treated units total and the number of empty matched sets.
}
\description{
A method for viewing summary data about the sizes of matched sets, the number of treated units, and the number of empty matched sets. If the quantity of interest is ate, then a summary will be provided for the matched sets associated with the att and the atc.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel,
                         lag = 4, 
                         refinement.method = "mahalanobis",
                         match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         lead = 0:4, forbid.treatment.reversal = FALSE)
summary(PM.results)

}
