% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary_str.R
\name{ternary_str}
\alias{ternary_str}
\title{Data structure with the  projected and boundary by node and class.}
\usage{
ternary_str(ppf, id, sp, dx, dy)
}
\arguments{
\item{ppf}{is a PPforest object}

\item{id}{is a vector with the selected projection directions}

\item{sp}{is the simplex dimensions, if k is the number of classes sp = k - 1}

\item{dx}{first direction included in id}

\item{dy}{second direction included in id}
}
\value{
Data frame needed to visualize a ternary plot
}
\description{
Data structure with the  projected and boundary by node and class.
}
\examples{
#crab data set with all the observations used as training
pprf.crab <- PPforest(data = crab, std ='min-max', y = "Type",
 size.tr = 1, m = 100, size.p = .5, PPmethod = 'LDA')
 require(dplyr)
pl_ter <- function(dat, dx, dy ){
  p1  <- dat[[1]] \%>\% dplyr::filter(pair \%in\% paste(dx, dy, sep = "-") ) \%>\%
    dplyr::select(Class, x, y) \%>\%
    ggplot2::ggplot(ggplot2::aes(x, y, color = Class)) +
    ggplot2::geom_segment(data = dat[[2]], ggplot2::aes(x = x1, xend = x2,
                                               y = y1, yend = y2), color = "black" ) +
    ggplot2::geom_point(size = I(3), alpha = .5) +
    ggplot2::labs(y = " ",  x = " ") +
    ggplot2::theme(legend.position = "none", aspect.ratio = 1) +
    ggplot2::scale_colour_brewer(type = "qual", palette = "Dark2") +
    ggplot2::labs(x = paste0("T", dx, " "), y = paste0("T", dy, " ")) +
    ggplot2::theme(aspect.ratio = 1)
  p1
}
#ternary plot in tree different selected dierections
 pl_ter(ternary_str(pprf.crab, id = c(1, 2, 3), sp = 3, dx = 1, dy = 2), 1, 2 )

}
\references{
da da Silva, N., Cook, D. & Lee, EK. Interactive graphics for visually diagnosing forest classifiers in R. Comput Stat 40, 3105–3125 (2025). https://doi.org/10.1007/s00180-023-01323-x
}
