% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsimpostppt.R
\name{dsimpostppt}
\alias{dsimpostppt}
\title{Posterior projected Polya Tree distribution}
\usage{
dsimpostppt(datafile,units = c("radians", "degrees", "hours"),
mm = 4, mu = c(0, 0), sig = 1, aa = 1, delta = 1.1,
it = 500, bi = 50, ti = 2, kapa = 0.5, ha = 0, hm = 0,
c0 = 1, c1 = 2, iota = 6, mu0 = 0, taum = 1, control.circular = list())
}
\arguments{
\item{datafile}{the data from which the estimate is to be computed. The object is circular or will be coerced to circular.}

\item{units}{units of the support: "radians", "degrees" or "hours".}

\item{mm}{number of finite levels of the Polya tree}

\item{mu}{mean vector of the projected bivariate normal centering distribution.}

\item{sig}{precision of the projected bivariate normal centering distribution.}

\item{aa}{alpha. Standard deviation parameter of the projected Polya tree.}

\item{delta}{controls of the speed at which the variances of the branching probabilities move down in the tree,  rho(m)=m^delta.}

\item{it}{number of iterations for MCMC.}

\item{bi}{number of burn in iterations for MCMC.}

\item{ti}{thinning parameter of the MCMC chain.}

\item{kapa}{tunning parameter in the MH proposal distribution for the latent resultants R.}

\item{ha}{logical. If TRUE alpha will be assigned Ga(c0,c1) hyper-prior distribution.}

\item{hm}{logical. If TRUE mu will be assigned N(mu0,taum) independent hyper-prior distributions for each coordinate.}

\item{c0, c1}{shape and rate hyper-parameters of the gamma prior distribution for alpha. These will be used only when ha=1.}

\item{iota}{tunning parameter in the MH proposal distribution for alpha.}

\item{mu0, taum}{mean and precision hyper-parameters of the independent normal prior distribution for each coordinate of mu. These will be used only when hm=1.}

\item{control.circular}{the attribute used to coerced the resulting. object. See circular.}
}
\value{
An object of class postppt.circ whose underlying structure is a list containing the following components:
\item{x}{points where the density is evaluated.}
\item{predictive}{predicitive density estimated with the projected Polya tree.}
\item{quantile2.5 quantile97.5}{lower and upper 95\% credible interval limits.}
\item{stats}{descriptive statistics: mean direction and concentration of each MCMC density.}
\item{cpo}{conditional predictive ordinate statistic for the data.}
\item{LMPL}{logarithm of the pseudo marginal likelihood statistic.}
\item{aa.sims}{vector of simulated alphas when ha=1.}
\item{mu.sims}{matrix of simulated bivariate means when hm=1.}
\item{acceptancerate}{Acceptance rate of MH step for the latent resultants.}
\item{acceptancerate_aa}{Acceptance rate of MH step for alpha.}
\item{data}{original dataset.}
}
\description{
Performs posterior inference for a given a circular dataset with the Projected Polya Tree via a MCMC algorithm.
}
\examples{
data(tapir)
#It is advised to increase the number of iterations for a better fitting
z1 <- dsimpostppt(tapir, units = "radians", it = 5, ti =1, bi=0, ha = 1, hm =1)
class(z1)
length(z1$acceptancerate)
z1$acceptancerate
\donttest{
postppt.summary(z1)
postppt.plot(z1, plot.type= "line" , ylim = c(0,0.8))
}
}
\references{
Nieto-Barajas, L.E. & Nunez-Antonio, G. (2019). Projected Polya tree. https://arxiv.org/pdf/1902.06020.pdf
}
\seealso{
\code{\link[PPTcirc]{postppt.plot}}, \code{\link[PPTcirc]{postppt.summary}}
}
