% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_param_surv_extrap}
\alias{f_plot_param_surv_extrap}
\title{Plot Extrapolated Parametric Survival Models per Group}
\usage{
f_plot_param_surv_extrap(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object returned by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
Invisibly returns \code{NULL}. The function draws one or more base R plots as side effects.
}
\description{
Plot Kaplan-Meier curves per group with shaded confidence bands and overlay
fitted parametric survival models (Exponential, Weibull, Gompertz, log-normal,
log-logistic, Gamma, generalized Gamma) extrapolated to the analysis time horizon.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_param_surv_extrap(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
