% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os.pred.R
\name{os.pred}
\alias{os.pred}
\title{Construct and apply the OmicSense model with your own data}
\usage{
os.pred(x, y, newx = x, method = "linear", thresh = 0, n.pred = 0)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of target value.}

\item{newx}{A data matrix (row: samples, col: predictors).}

\item{method}{A string to specify the regression function for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" function can be specified.}

\item{thresh}{The lower threshold of R-squared value to be leaved in prediction model (default: 0).}

\item{n.pred}{The number of candidate predictors to be leaved in prediction model (default: 30).}
}
\value{
A vector of the environment in which the samples of newx were collected
}
\description{
Construct and apply the OmicSense model with your own data
}
\examples{
data(Pinus)
train <- os.clean(Pinus$train)
test <- Pinus$test
test <- test[, colnames(train)]
target <- Pinus$target
cor(target, os.pred(train, target, newx = test, method = "cubic"))
}
\author{
Takahiko Koizumi
}
