% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationPlots.R
\name{plotCmEstimates}
\alias{plotCmEstimates}
\title{Plots the cohort method results for one analysis}
\usage{
plotCmEstimates(
  cmData,
  cmMeta = NULL,
  targetName,
  comparatorName,
  selectedAnalysisId
)
}
\arguments{
\item{cmData}{The cohort method data}

\item{cmMeta}{(optional) The cohort method evidence synthesis data}

\item{targetName}{A friendly name for the target cohort}

\item{comparatorName}{A friendly name for the comparator cohort}

\item{selectedAnalysisId}{The analysis ID of interest to plot}
}
\value{
Returns a ggplot with the estimates
}
\description{
Creates nice cohort method plots
}
\details{
Input the cohort method data
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cmEst <- getCMEstimation(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)
plotCmEstimates(
  cmData = cmEst, 
  cmMeta = NULL, 
  targetName = 'target', 
  comparatorName = 'comp', 
  selectedAnalysisId = 1
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
