% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{opiSetup_for_Octopus900}
\alias{opiSetup_for_Octopus900}
\title{Implementation of opiSetup for the Octopus900 machine.}
\arguments{
\item{lum}{Luminance level in cd/m^2}

\item{color}{Stimulus color (see details)}

\item{fixation}{fixation target}

\item{fixIntensity}{fixation point intensity}
}
\value{
A list with element \code{err} which is
\itemize{
\item NULL on success
\item -1 indicates \code{opiInitialize} has not been called.
\item -2 indicates could not set the background color.
\item -3 indicates could not set the fixation marker.
\item or a string message about bad parameters
}
}
\description{
This is for internal use only.
Use \code{\link[=opiSetup]{opiSetup()}} with the same parameters.
}
\details{
Allowable \code{lum} and \code{color} are defined in the \code{.opi_env$O900} environment.
\itemize{
\item \code{lum} is intensity of the background and can be one of
\itemize{
\item \code{.opi_env$O900$BG_OFF}, which turns background off.
\item \code{.opi_env$O900$BG_1}, background of 1.27 cd/\eqn{\mbox{m}^2}{m^2}.
\item \code{.opi_env$O900$BG_10}, background of 10 cd/\eqn{\mbox{m}^2}{m^2}.
\item \code{.opi_env$O900$BG_100}, background of 100 cd/\eqn{\mbox{m}^2}{m^2}.
}
\item \code{color} can be one of the following choices.
\itemize{
\item \code{.opi_env$O900$MET_COL_WW} for white-on-white
\item \code{.opi_env$O900$MET_COL_RW} for red-on-white
\item \code{.opi_env$O900$MET_COL_BW} for blue-on-white
\item \code{.opi_env$O900$MET_COL_WY} for white-on-yellow
\item \code{.opi_env$O900$MET_COL_RY} for red-on-yellow
\item \code{.opi_env$O900$MET_COL_BY} for blue-on-yellow
}
\item \code{fixation} is one of
\itemize{
\item \code{.opi_env$O900$FIX_CENTRE} or \code{.opi_env$O900$FIX_CENTER}
\item \code{.opi_env$O900$FIX_CROSS}
\item \code{.opi_env$O900$FIX_RING}
}
\item \code{fixIntensity} is a percentage between 0 and 100. 0 is off, 100 the brightest.
}

Note if you specify \code{fixation} you also have to specify \code{fixIntensity}.
}
\examples{
\dontrun{
  chooseOpi("Octopus900")
  oi <- opiInitialize(eyeSuiteJarLocation="c:/EyeSuite/",
                      eyeSuiteSettingsLocation="c:/Documents and Settings/All Users/Haag-Streit/",
                      eye="left")
  if(!is.null(oi$err))
      stop("opiInitialize failed")
  if(!is.null(opiSetup(fixation=.opi_env$O900$FIX_CENTRE)$err))
      stop("opiSetup failed")
  if(!is.null(opiSetup(fixation=.opi_env$O900$FIX_RING, fixIntensity=0)$err))
      stop("opiSetup failed")
  if(!is.null(opiSetup(color=.opi_env$O900$MET_COL_BY)$err))
      stop("opiSetup failed")
  if(!is.null(opiSetup(lum=.opi_env$O900$BG_100, color=.opi_env$O900$MET_COL_RW)$err))
      stop("opiSetup failed")
  opiClose()
}
}
