% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.xyplot}
\alias{nos.xyplot}
\title{nos.xyplot text-based scatter plot.}
\usage{
nos.xyplot(x = 1:length(y), y, xlab = NULL, ylab = NULL, ratio = 0.25,
  width = round(options()$width * 0.8), height = round(ratio * width),
  pch = c("o", "~"), type = "p")
}
\arguments{
\item{x}{A numeric vector containing the x-values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{y}{A numeric vector containing the y-values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ylab}{Label of the y-axis of the plot.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A two dimensional vector of single-character symbols. The first symbol is for the x and y coordinate points, and the second symbol is for the interpolation or regression line.}

\item{type}{One of the values in the set \code{c('l','p','r','lp','pr')}. Type \code{'l'} plots a linear interpolation, type \code{'p'} plots the x and y coordinates as points, type \code{'r'} plots a linear regression line, type \code{'lp'} plots x and y coordinates along with a linear interpolation, and type \code{'pr'} plots x and y coordinates along with a linear regression line.}
}
\description{
Plots a text-based scatter plot, with the option of having a regression line, or a linear interpolation of the points.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position.
}
\examples{
## Plot 10 correlated points
x <- 10*runif(10)
y <- x + rnorm(10)
nos.xyplot(x,y,type='p',xlab='x',ylab='y')

## Plot 10 correlated points with a regression line
x <- 10*runif(10)
y <- x + rnorm(10)
nos.xyplot(x,y,type='pr',xlab='x',ylab='y')

## Plot 10 correlated points with a linear interpolation
x <- 10*runif(10)
y <- x + rnorm(10)
nos.xyplot(x,y,type='lp',xlab='x',ylab='y')
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[graphics]{plot}} and \code{\link[txtplot]{txtplot}}.
}

