% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.qqplot}
\alias{nos.qqplot}
\title{nos.qqplot text-based generic quantile-quantile plots}
\usage{
nos.qqplot(x, y, xlab = NULL, ylab = NULL, line = T, ratio = 0.25,
  width = round(options()$width * 0.8), height = round(ratio * width),
  pch = c("o", "~"))
}
\arguments{
\item{x}{A numeric vector containing the values to be plotted along the x-axis. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{y}{A numeric vector containing the values to be plotted along the y-axis. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ylab}{Label of the y-axis of the plot.}

\item{line}{If \code{TRUE}, the line of theoretical quantile equality is plotted. If \code{FALSE}, then the line of theoretical quantile equality is not plotted.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A two dimensional vector of single-character symbols. The first symbol is for data point, and the second symbol is for the line of theoretical quantile equality.}
}
\description{
Produces a text-based quantile-quantile plot between two equal size samples, with the option of plotting a line of theoretical quantile equality.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position.
}
\examples{
## Produce a quantile-quantile plot between two samples of 10 random standard normal points,
## without the line of theoretical quantile equality.
x <- rnorm(10)
y <- rnorm(10)
nos.qqplot(x,y,line=FALSE)

## Produce a quantile-quantile plot of 100 random chi-squared(3) points against the
## true theoretical distribution, with the line of theoretical quantile equality.
y <- rchisq(100,3)
x <- qchisq(ppoints(100),3)
nos.qqplot(x,y,xlab='Theoretical Qs',ylab='Sample Qs')
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[stats]{qqplot}}, \code{\link[stats]{qqline}}, \code{\link[stats]{ppoints}}, and \code{\link[txtplot]{txtplot}}.
}

