% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCCsampling.R
\name{LCCsampling}
\alias{LCCsampling}
\title{Local case control sampling for logistic regression}
\usage{
LCCsampling(r0,rf,Y,X,N)
}
\arguments{
\item{r0}{sample size for initial random sample}

\item{rf}{final sample size including initial(r0) and case control(r) samples}

\item{Y}{response data or Y}

\item{X}{covariate data or X matrix that has all the covariates (first column is for the intercept)}

\item{N}{size of the big data}
}
\value{
The output of \code{LCCsampling} gives a list of

\code{Beta_Estimates} estimated model parameters in a data.frame after sampling

\code{Sample_LCC_Sampling} list of indexes for the initial and optimal samples obtained based on local case control sampling

\code{Sampling_Probability} vector of calculated sampling probabilities for local case control sampling
}
\description{
Using this function sample from big data under logistic regression to describe the data.
Sampling probabilities are obtained based on local case control method.
}
\details{
Two stage sampling algorithm for big data under logistic regression.

First obtain a random sample of size \eqn{r_0} and estimate the model parameters.
Using the estimated parameters sampling probabilities are evaluated for local case control.

Through the estimated sampling probabilities an optimal sample of size \eqn{r \ge r_0} is obtained.
Finally, the optimal sample is used and the model parameters are estimated.

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.

If \eqn{r \ge r_0} is not satisfied then an error message will be produced.

If the big data \eqn{X,Y} has any missing values then an error message will be produced.

The big data size \eqn{N} is compared with the sizes of \eqn{X,Y} and if they are not aligned an error
message will be produced.
}
\examples{
Dist<-"Normal"; Dist_Par<-list(Mean=0,Variance=1)
No_Of_Var<-2; Beta<-c(-1,2,1); N<-10000; Family<-"logistic"
Full_Data<-GenGLMdata(Dist,Dist_Par,No_Of_Var,Beta,N,Family)

r0<-300; rf<-rep(100*c(6,9,12),50); Original_Data<-Full_Data$Complete_Data;

LCCsampling(r0 = r0, rf = rf, Y = as.matrix(Original_Data[,1]),
            X = as.matrix(Original_Data[,-1]),
            N = nrow(Original_Data))->Results

plot_Beta(Results)

}
\references{
\insertRef{fithian2015local}{NeEDS4BigData}
}
