% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCovs.R
\name{sampleCovs}
\alias{sampleCovs}
\title{Sample subject-level covariates from an existing data set}
\usage{
sampleCovs(
  data,
  Nsubjs,
  col.id = "ID",
  col.id.covs = "ID",
  data.covs,
  covs,
  seed.R,
  as.fun
)
}
\arguments{
\item{data}{A simulation data set with only one subject}

\item{Nsubjs}{The number of subjects to be sampled. This can be
greater than the number of subjects in data.covs.}

\item{col.id}{Name of the subject ID column in `data` (default is "ID").}

\item{col.id.covs}{Name of the subject ID column in `data.covs`
(default is "ID").}

\item{data.covs}{The data set containing the subjects to sample covariates from.}

\item{covs}{The name of the covariates (columns) to sample from `data.covs`.}

\item{seed.R}{If provided, passed to `set.seed()`.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data.frame
}
\description{
Repeats a data set with just one subject by sampling covariates
from subjects in an existing data set. This can conveniently be
used to generate new subjects with covariate resampling from an
studied population.
}
\examples{
library(NMdata)
data.covs <- NMscanData(system.file("examples/nonmem/xgxr134.mod",package="NMsim"))
dos.1 <- NMcreateDoses(TIME=0,AMT=100) 
data.sim.1 <- NMaddSamples(dos.1,TIME=c(1,4),CMT=2)
sampleCovs(data=data.sim.1,Nsubjs=3,col.id.covs="ID",data.covs=data.covs,covs=c("WEIGHTB","eff0"))
}
