% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_DSM.R
\name{SPC_DSM}
\alias{SPC_DSM}
\title{SPC_DSM}
\usage{
SPC_DSM(specdat, withBC = TRUE)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data}

\item{withBC}{A logical parameter that enables/disables baseline correction after baseline correction}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
A single linear model with dispersion summation minimization.
}
\details{
This function is to process phase error correction through a single linear model with dispersion summation minimization,
followed by polynomial baseline correction if necessary
}
\examples{
data("fdat")
spc_dsm_phased1 <- SPC_DSM(fdat$frequency_domain)
}
\references{
Binczyk, F., Tarnawski, R., & Polanska, J. (2015). Strategies for optimizing the phase correction algorithms in Nuclear Magnetic Resonance spectroscopy. Biomedical Engineering Online, 14 Suppl 2(Suppl 2), S5. https://doi.org/10.1186/1475-925X-14-S2-S5

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
