% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_counts.R
\name{NullModel}
\alias{NullModel}
\alias{NullModelTest}
\title{Calculate the Normalized Counts and Related Training Parameters.}
\usage{
NullModel(x, type = c("mle", "deseq", "quantile", "none", "tmm"))

NullModelTest(null.out, xte = NULL)
}
\arguments{
\item{x}{an n-by-p data frame or matrix of count data. Samples should be in the rows.}

\item{type}{the normalization method. See \code{\link{control}} for details.}

\item{null.out}{an object returned from \code{\link{NullModel}}.}

\item{xte}{an n-by-p count matrix or data frame of test set. These counts are normalized using the training set parameters.}
}
\value{
a list with the normalized counts and the training set parameters that are used for normalizing the raw counts.
}
\description{
Fit a training set to the NBLDA model and estimate normalized counts. The related model parameters, which are used while normalizing training sets, are also returned to normalize test sets using training set parameters.
}
\note{
These functions are copied from the \code{PoiClaClu} package and modified here to make "tmm" and "none" methods available.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5, DE = 0.8,
                            allZero.rm = FALSE, tag.samples = TRUE)
x <- counts$x
xte <- counts$xte

x.out <- NullModel(x, "mle")
x.out$n ## Normalized counts using "mle" method

xte.out <- NullModelTest(x.out, xte)
xte.out$n  # Normalized counts for test set using train set parameters.

}
\author{
Dincer Goksuluk
}
