% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultipleBreakpoints.R
\name{multiple_breakpoints}
\alias{multiple_breakpoints}
\title{Estimating Multiple Breakpoints for a Sequence of Realizations of
Bernoulli Variables}
\usage{
multiple_breakpoints(
  data,
  number_bp = "Unknown",
  max_bp = 80,
  inf_crit = "BIC",
  ext_out = "TRUE"
)
}
\arguments{
\item{data}{A two-column matrix with the location in the first column and
the corresponding realizations of the Bernoulli variables in the second
column, a vector with the ordered, realizations of the Bernoulli variables or
an equivalent data frame. Note that the realizations of the vector
respectively the second column of the matrix or the data frame must be zero
or one for each element.}

\item{number_bp}{Number of breakpoints if known a priori. By default, the
number of breakpoints is unknown.}

\item{max_bp}{The maximum number of breakpoints to be estimated (just for the
case, where the number of breakpoints is unknown a priori and the chosen
information criterion does not stop the procedure before)}

\item{inf_crit}{Must be one of "BIC" (Bayesian Information Criterion,
default), "HQC" (Hannan-Quinn Criterion) or "AIC" (Akaike Information
Criterion)}

\item{ext_out}{If TRUE (default), all function values are stored in the
iterative procedure and hidden printed in the output afterwards. This may take
additional computing time in large data sets or simulation studies. For the
method \link[=plot.mBP]{plot}, the default setting is required.}
}
\value{
A list containing the following elements:
\item{Breakpoints}{A vector containing the estimated breakpoints in
increasing order.}
\item{Probabilities}{A vector containing the estimated success
probabilities in each class.}
\item{Information Criterion}{A vector containing the values of the chosen
Information Criterion before the first iteration (thus without a breakpoint)
and after each new estimated breakpoint}
\item{S}{Only available, if ext_out set to TRUE. A matrix
containing the function values, each column representing one iteration}
}
\description{
The iterative procedure estimates structural changes in the
success probability of Bernoulli variables. It estimates the number and
location of the breakpoints as well as the success probabilities of the
sequences between each pair of neighbouring breakpoints.
}
\examples{
mBP <- multiple_breakpoints(c(rbinom(1000, 1, 0.5),
                            rbinom(1000, 1, 0.1),
                            rbinom(1000, 1, 0.2)))
plot(mBP)
multiple_breakpoints(matrix(c(sort(rnorm(1000)),
                            rbinom(500, 1, 0.5),
                            rbinom(500, 1, 0.1)), ncol = 2),
                            inf_crit = "HQC")
multiple_breakpoints(matrix(c(sort(rnorm(1500)),
                            rbinom(500, 1, 0.1),
                            rbinom(500, 1, 0.3),
                            rbinom(500, 1, 0.4)), ncol = 2), number_bp = 2)
multiple_breakpoints(matrix(c(1:200, rep(201,5), 202:396,
                            rbinom(250,1,0.9), rbinom(150,1,0.75)),
                            ncol = 2), number_bp = 1)
}
\references{
\insertRef{froelich}{MultipleBreakpoints}
}
\seealso{
S3 method \link[=plot.mBP]{plot} for the class "mBP".
}
\author{
Nicolas Froelich
}
