% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_sampler.R
\name{com_sampler}
\alias{com_sampler}
\title{Rejection Sampler - COM-Poisson}
\usage{
com_sampler(mu, nu, n = 1, ndraws = FALSE)
}
\arguments{
\item{mu}{Location parameter}

\item{nu}{Shape parameter}

\item{n}{Number of draws (default = 1)}

\item{ndraws}{Optional: Return the number of draws required to generate the n samples.}
}
\value{
A list or numeric in case ndraws = FALSE:
\item{sample}{Values sampled from the distribution}
\item{drawsa}{Number of draws required in the rejection sampler}
\item{log_Bf}{Log of the boundary of the rejection sampler}
}
\description{
Sampler for the Conway-Maxwell-Poisson as described in Algorithm 2 - Benson & Friel (2021)
}
\examples{
com_sampler(2, 0.2, n = 10, ndraws = TRUE)
com_sampler(1, 2)
}
