% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstruct}
\alias{reconstruct}
\title{Apply a clustering algorithm to a given time course.}
\usage{
reconstruct(
  readouts,
  target_communities,
  method = "kmedoids",
  sim = MultIS::get_similarity_matrix(readouts = readouts, upper = TRUE),
  cluster_obj = FALSE
)
}
\arguments{
\item{readouts}{The time course for which to find clusters.}

\item{target_communities}{The number of clusters to cluster for.}

\item{method}{Either "kmedoids", "kmeans" or any string permitted as a
method for stats::hclust.}

\item{sim}{A similarity matrix used with all methods except "kmeans".}

\item{cluster_obj}{If TRUE, a clusterObject with the readouts, similarity
and clustering is returned.}
}
\value{
A matrix with two columns: "Clone" and "IS" or if
        cluster_obj = TRUE a cluster object, which can be used to plot the
        clustering.
}
\description{
Apply a clustering algorithm to a given time course.
}
