\name{PolyBiplot}
\alias{PolyBiplot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Logistic Biplot for ordinal data based on polychoric correlations
}
\description{
Calculates a Logistic Biplot for ordinal data based on the factorization of the matrix of polychoric correlations.
}
                       
\usage{
PolyBiplot(X, dim = 2, fm = "pca", rotate = "none", 
           OptimMethod = "CG", penalization = 0, ML = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
The data matrix
}
  \item{dim}{
Dimension of the solution
}
  \item{fm}{
Factoring method. Either "pca" for Principal components analysis or any method for the functio "fa" of the package "psych"}
  \item{rotate}{
Rotation method as in package "psych"
}
  \item{OptimMethod}{
Optimitation method for the gradient to calculate the socres for individuals
}
  \item{penalization}{
Penalization for the gradient. Default = 0.
}
  \item{ML}{
Should I use the maximum liikelihood method to calculate the polychoric correlations?
}
}
\details{
Calculates a Logistic Biplot for ordinal data based on the factorization of the matrix of polychoric correlations. 
The factorization can be any provided by the functions "principal" and "fa"of the package 
}
\value{
An object of class "Ordinal.Logistic.Biplot"


\item{Data }{The original da matrix with odinal variables in nmeric format}
\item{Dimension }{The dimension of the solution}
\item{Penalization }{The quadratic penalization used in the algorithm}
\item{Tolerance }{The tolerance used in the algorithm}
\item{OptimMethod }{The optimization method used in the algorithm (see optim)}
\item{Biplot }{The kind of biplot used (Ordinal Logistic (Factorization of the polychoric matrix))}
\item{Type }{The type of biplot used (Ordinal Logistic (Factorization of the polychoric matrix))}
\item{NumberIterations}{The maximum number of iterations used by the lgorithm.}
\item{RowCoordinates}{Coordinates for the rows of the matrix.}
\item{RowContributions}{Contributions for the rows of the matrix. (not used yet)}
\item{ColCoordinates}{Coordinates for the columns of the matrix.}
\item{loadings}{Loadings of the factor model.}
\item{Thresholds}{Thresholds of the model.}
\item{Communalities}{Communalities of the factor model.}
\item{ColContributions}{Contributions for the columns of the matrix. (squared loadings)}
\item{Expected}{Expected Values}
\item{ColumnParameters}{Several column parameters (not used directly)}
\item{Fit}{Several measures of fit in a table}
\item{Ncats}{Number of categories of each item}

}
\references{
Valdés Rodriguez,  M., Vicente-González,  L., & Vicente-Villardón,  J. L. (2025). Factor Analysis Biplots for Continuous, 
Binary and Ordinal Data. Preprints. https://doi.org/10.20944/preprints202510.0280.v1
}
\author{
Jose Luis Vicente Villardón
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
For methods of factorization see  \code{help("principal")} and \code{help("fa")}.
}
\examples{
bipord=PolyBiplot(DoctorsNUM)
plot(bipord)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
