PolyBiplot <- function(X, dim=2,  fm="pca",  rotate="none", OptimMethod="CG",
                       penalization=0, ML=FALSE) {
  mycall=match.call()
  print("Initializating")
  dimens=dim
  
  X=as.matrix(X)

  I = dim(X)[1] 
  J = dim(X)[2]
  
  
  IndNames=rownames(X)
  VarNames=colnames(X)
  
  ncats=apply(X,2, max)
  maxcat=max(ncats)
  
  # Matrix of category indicators P
  P=NULL
  Nombres=NULL
  for (j in 1:J){
    for (k in 1:(ncats[j])){
      P=cbind(P,as.numeric(X[,j]==k))
      Nombres=cbind(Nombres,paste(VarNames[j],k, sep="-"))
    }
  }
  colnames(P)=Nombres
  rownames(P)=IndNames
  
  # Matrix of cummulative categories C
  C=NULL
  Nombres=NULL
  for (j in 1:J){
    for (k in 1:(ncats[j]-1)){
      C=cbind(C,as.numeric(X[,j]<=k))
      Nombres=cbind(Nombres,paste(VarNames[j],k, sep="<="))
    }
  }
  L=dim(C)[2]
  colnames(C)=Nombres
  rownames(C)=IndNames
  
  print("Calculating  polychoric correlation")
  # Calculation of polychoric correlation
  if (sum(ncats==maxcat)==J){
    print("for equal number of alternatives")
    Polychor=psych::polychoric(X)
    R=Polychor$rho
    Thresholds=Polychor$tau
  }
  else{
    print("for unequal number of alternatives")
    Polychor=PolychorMatrix(X, ML=ML)
    R=Polychor$R
    Thresholds=matrix(0, J, maxcat-1)
    for (j in 1:J){
      
      Thresholds[j, 1:(ncats[j]-1)]=Polychor$Thresholds[[j]][1:(ncats[j]-1)]}
    rownames(Thresholds)=VarNames
    colnames(Thresholds)=paste("CAT",1:(maxcat-1))
  }
  
  valores=eigen(R)$values
  if (sum(valores<0)>1){
    print("The correlation matrix is not positive definited and has been approximated")
    R=Matrix::nearPD(R, keepDiag = TRUE)$mat
    R=as.matrix(R)
  }
  
  
  print("Factorization of the correlation matrix")
  # Factorization of the correlation matrix
  
  if (fm =="pca")
    pc <- principal(R, nfactors=dimens, n.obs=I, rotate=rotate)
  else
    pc <- fa(R, nfactors=dimens, n.obs=I, rotate=rotate, fm=fm)
  
  Loadings=matrix(pc$loadings, nrow=J)
  
  Communalities=apply(Loadings^2, 1, sum)
  
  B=diag(sqrt(1-Communalities))%*%Loadings
  D=diag(sqrt(1-Communalities))%*%Thresholds
  
  #B=-1*B
  
  d=NULL
  for (j in 1:J){
    d=c(d, D[j,1:(ncats[j]-1)])
  }
  d=matrix(d,ncol=1)
  
  print("Calculating scores for individuals")
  A=NULL
  for (k in 1:dimens){
    parA=rnorm(I)
    A=cbind(A,parA)
    BP=matrix(B[,1:k], ncol=k)
    resbipA <- optim(parA, fn=JOrdLogBiplotAdifcats, gr=grOrdLogBiplotAdifcats, method=OptimMethod, C=C, d=d, A=A, B=BP, ncats=ncats, lambda=penalization)
    parA=resbipA$par
    A[,k]=parA
  }
  
  print("Finishing Calculations")
  

  rownames(A)=IndNames
  colnames(A)=paste("dim",1:dimens)
  rownames(B)=VarNames
  colnames(B)=paste("dim",1:dimens)
  
  model=list()
  model$Data=X
  model$Dimension=dimens
  
  model$OptimMethod=OptimMethod
  model$Biplot="Ordinal Logistic (Factorization of the polychoric matrix)"
  model$Type= "Ordinal Logistic (Factorization of the polychoric matrix)"
  
  model$Penalization=penalization
  
  model$RowCoordinates=A
  model$ColCoordinates=B
  model$Thresholds=D
  
  model$RowContributions=matrix(100/dimens,I,dimens)
  rownames(model$RowContributions)=IndNames
  colnames(model$RowContributions)=paste("Dim_",1:dimens,sep="")
  
  model$loadings = Loadings
  rownames(model$loadings)=VarNames
  colnames(model$loadings)=paste("Dim", 1:dimens)
  model$Communalities = matrix(Communalities, ncol=1)
  rownames(model$Communalities)=VarNames
  colnames(model$Communalities)="Communalities"
  model$ColContributions = Loadings^2 
  rownames(model$ColContributions)=VarNames
  
  par=ExpectedOrdinalBiplot(X, C, d, A, B)
  model$Expected=par$Expected
  rownames(par$coefficients) = VarNames
  colnames(par$coefficients) = paste("Dim_",1:dimens,sep="")
  par$thresholds=D
  rownames(par$thresholds) = VarNames
  
  colnames(par$thresholds) = paste("C_",1:(maxcat-1),sep="")
  
  model$ColumnParameters = par
  model$Fit=par$fit
  model$Ncats=par$Ncats
  
  class(model) = "Ordinal.Logistic.Biplot"
  
  model$ClusterType="us"
  model$Clusters = as.factor(matrix(1,I, 1))
  model$ClusterColors="blue"
  model$ClusterNames="ClusterTotal"
  class(model) = "Ordinal.Logistic.Biplot"
  return(model)
}
