% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_unemployment.R
\name{get_mexico_unemployment}
\alias{get_mexico_unemployment}
\title{Get Mexico's Unemployment Rate from World Bank}
\usage{
get_mexico_unemployment()
}
\value{
A tibble with four columns: `indicator` (name of the indicator),
`country` (country name), `year` (year of observation), and `value`
(unemployment rate as a numeric percentage).
}
\description{
Retrieves Mexico's total unemployment rate as a percentage of the total labor force
from 2010 to 2022 using the World Bank Open Data API.
}
\details{
The function sends a GET request to the World Bank API. If the request fails or returns a status
other than 200, the function returns \code{NULL} with an informative message.
}
\note{
This function requires an internet connection.
}
\examples{
\dontrun{
get_mexico_unemployment()
}

}
\seealso{
\link[httr]{GET}, \link[jsonlite]{fromJSON}, \link[dplyr]{as_tibble}
}
