% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-1.layout.R
\name{spatstat_layout}
\alias{spatstat_layout}
\title{Generate spatial layout using \code{spatstat}}
\usage{
spatstat_layout(
  go,
  win,
  type = c("random", "regular"),
  mode = c("surface", "boundary"),
  jitter = 0,
  curved = NULL,
  order_by = NULL,
  order_ls = NULL,
  order_circle = FALSE,
  seed = 1234,
  rescale = TRUE
)
}
\arguments{
\item{go}{igraph or metanet object}

\item{win}{A spatstat window object (owin), e.g. disc(), owin(poly=...); Or sf object.}

\item{type}{Type of distribution: "random", "regular"}

\item{mode}{"surface", "boundary"}

\item{jitter}{for surface-regular, defalut 0}

\item{curved}{Optional curved attribute for coors}

\item{order_by}{order nodes according to a node attribute}

\item{order_ls}{manual the discrete variable with a vector, or continuous variable with "desc" to decreasing}

\item{order_circle}{order nodes from the center of a circle}

\item{seed}{random seed}

\item{rescale}{rescale the coordinates to (0,1)}
}
\value{
A coors object (data.frame with class "coors" and attribute "curved")
}
\description{
Generate spatial layout using \code{spatstat}
}
\examples{
\donttest{
if (requireNamespace("spatstat.geom") && requireNamespace("spatstat.random")) {
  poly_x <- c(0, 2, 2, 0)
  poly_y <- c(0, 0, 1, 1)
  win_poly <- spatstat.geom::owin(poly = list(x = poly_x, y = poly_y))
  plot(win_poly)
  coors1 <- spatstat_layout(co_net, win_poly, type = "regular", mode = "surface")
  plot(co_net, coors = coors1)
  coors2 <- spatstat_layout(co_net2, win_poly, type = "random", mode = "boundary")
  plot(co_net2, coors = coors2)

  if (requireNamespace("sf")) {
    nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
    poly <- nc[1, ]
    coors <- spatstat_layout(go = multi1, win = poly, type = "regular", mode = "surface")
    plot(multi1, coors = coors)
  }
}
}
}
