% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.modules.R
\name{filter_n_module}
\alias{filter_n_module}
\alias{combine_n_module}
\alias{plot_module_tree}
\title{Filter some modules as others}
\usage{
filter_n_module(go_m, n_node_in_module = 0, keep_id = NULL, delete = FALSE)

combine_n_module(go_m, module_number = 5)

plot_module_tree(go_m, module = "module", community = NULL, label.size = 2)
}
\arguments{
\item{go_m}{module metanet}

\item{n_node_in_module}{transfer the modules less than n_node_in_module to "others"}

\item{keep_id}{keep modules ids, will not be "others"}

\item{delete}{logical, delete others modules? default:FALSE, the others module will be "others".}

\item{module_number}{number of modules}

\item{module}{which column name is module. default: "module"}

\item{community}{community object, default: NULL, use the community of go_m}

\item{label.size}{label.size}
}
\value{
metanet with modules

ggplot
}
\description{
Filter some modules as others

Combine or cut modules to module_number

Plot module tree
}
\examples{
data("c_net")
module_detect(co_net) -> co_net_modu
filter_n_module(co_net_modu, n_node_in_module = 30) -> co_net_modu
if (requireNamespace("ggtree") && requireNamespace("treeio")) plot_module_tree(co_net_modu)
combine_n_module(co_net_modu, 20) -> co_net_modu1
if (requireNamespace("ggtree") && requireNamespace("treeio")) plot_module_tree(co_net_modu1)
}
\seealso{
Other module: 
\code{\link{get_community}()},
\code{\link{get_module}()},
\code{\link{get_module_eigen}()},
\code{\link{module_detect}()},
\code{\link{module_eigen}()},
\code{\link{module_net}()},
\code{\link{summary_module}()},
\code{\link{to_module_net}()},
\code{\link{zp_analyse}()}
}
\concept{module}
