% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_POLRModel.R
\name{POLRModel}
\alias{POLRModel}
\title{Ordered Logistic or Probit Regression Model}
\usage{
POLRModel(method = c("logistic", "probit", "loglog", "cloglog", "cauchit"))
}
\arguments{
\item{method}{logistic or probit or (complementary) log-log or cauchit
(corresponding to a Cauchy latent variable).}
}
\value{
\code{MLModel} class object.
}
\description{
Fit a logistic or probit regression model to an ordered factor response.
}
\details{
\describe{
  \item{Response types:}{\code{ordered}}
}

Further model details can be found in the source link below.

In calls to \code{\link{varimp}} for \code{POLRModel}, numeric argument
\code{base} may be specified for the (negative) logarithmic transformation of
p-values [defaul: \code{exp(1)}].  Transformed p-values are automatically
scaled in the calculation of variable importance to range from 0 to 100.  To
obtain unscaled importance values, set \code{scale = FALSE}.
}
\examples{
data(Boston, package = "MASS")

df <- within(Boston,
             medv <- cut(medv,
                         breaks = c(0, 10, 15, 20, 25, 50),
                         ordered = TRUE))
fit(medv ~ ., data = df, model = POLRModel)

}
\seealso{
\code{\link[MASS]{polr}}, \code{\link{fit}}, \code{\link{resample}}
}
