% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_estimation.R
\name{mcee_helper_stage1_fit_nuisance}
\alias{mcee_helper_stage1_fit_nuisance}
\title{Fit all nuisance models for MCEE Stage 1}
\usage{
mcee_helper_stage1_fit_nuisance(
  data,
  id_var,
  dp_var,
  outcome_var,
  treatment_var,
  mediator_var,
  avail_var,
  config_p,
  config_q,
  config_eta,
  config_mu,
  config_nu
)
}
\arguments{
\item{data}{Data frame in long format.}

\item{id_var, dp_var, outcome_var, treatment_var, mediator_var, avail_var}{Character column names (same as in \code{\link{mcee_helper_2stage_estimation}}).}

\item{config_p, config_q, config_eta, config_mu, config_nu}{Configuration lists
for each nuisance parameter (see \code{\link{mcee_config_maker}}).}
}
\value{
List with two components:
\describe{
  \item{\code{nuisance_fitted}}{List of numeric vectors (length \code{nrow(data)}) containing
    per-row predictions: \code{p1}, \code{p0}, \code{q1}, \code{q0}, \code{eta1},
    \code{eta0}, \code{mu1}, \code{mu0}, \code{nu1}, \code{nu0}.}
  \item{\code{nuisance_models}}{List of fitted model objects or "known" descriptors:
    \code{p}, \code{q}, \code{eta1}, \code{eta0}, \code{mu1}, \code{mu0}, \code{nu1}, \code{nu0}.}
}
}
\description{
Fits all five nuisance components required for MCEE estimation and returns both
per-row predictions and fitted model objects. This is Stage 1 of the two-stage
MCEE procedure.
}
\details{
**Nuisance Parameters Fitted:**
\itemize{
  \item \code{p}: Propensity score \eqn{P(A_t=1\mid H_t)} - fitted on available rows. (Technically,
  this is \eqn{P(A_t=I_t\mid H_t)}, but the user is allowed to input \eqn{P(A_t=1\mid H_t)}
  and the function will automatically correct it by setting \code{p1 = 1} when \eqn{I_t = 0}.)
  \item \code{q}: Conditional propensity \eqn{P(A_t=1\mid H_t, M_t)} - fitted on available rows. (Technically,
  this is \eqn{P(A_t=I_t\mid H_t, M_t)}, but the user is allowed to input \eqn{P(A_t=1\mid H_t, M_t)}
  and the function will automatically correct it by setting \code{q1 = 1} when \eqn{I_t = 0}.)
  \item \code{eta1}, \code{eta0}: Outcome regression \eqn{E(Y\mid A_t=a, H_t)} without mediator
  \item \code{mu1}, \code{mu0}: Outcome regression \eqn{E(Y\mid A_t=a, H_t, M_t)} with mediator
  \item \code{nu1}, \code{nu0}: Cross-world regressions for counterfactual outcomes
}

**Data Subsets Used for Fitting:**
- \code{p}, \code{q}: Only rows where \code{availability==1}
- \code{eta1}, \code{mu1}: Rows where \code{A==1} OR \code{availability==0}
- \code{eta0}, \code{mu0}: Rows where \code{A==0}
- \code{nu1}: Fitted on \code{A==0} rows using \code{mu1} predictions as outcome
- \code{nu0}: Fitted on \code{A==1} or unavailable rows using \code{mu0} predictions as outcome

**Availability Handling:**
When \code{availability==0}, predictions are forced to \code{p1=p0=q1=q0=1} to
prevent division by zero in Stage 2.
}
