% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wscale.R
\name{wscale}
\alias{wscale}
\title{Scale of Sampling Weights}
\usage{
wscale(cluster, data, wt, type = "cluster")
}
\arguments{
\item{cluster}{The cluster variable.}

\item{data}{The original dataset.}

\item{wt}{The weight variable to scale.}

\item{type}{Either \code{cluster} or \code{ecluster}. See pdf from Mplus website.}
}
\description{
Uses the \code{cluster} and \code{ecluster} (cluster size and effective cluster size) options specified in Mplus. See \href{https://statmodel.com/download/Scaling3.pdf}{note} from the Mplus website.
If there is no variation in weights within a cluster, the weights will scale to 1.
}
\examples{
data(pisa2012, package = 'MLMusingR')
pisa2012$clustwt <- wscale('schoolid', pisa2012, 'w_fschwt')
}
