% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-CLE.R
\name{step_CLE}
\alias{step_CLE}
\title{Make Chemical Langevin (CLE) Sampler for a SPN model}
\usage{
step_CLE(S, Sout, haz, dt = 0.01, maxhaz = 1e+06)
}
\arguments{
\item{S}{a stoichiometry \code{\link[Matrix]{Matrix-class}} object}

\item{Sout}{an optional matrix to track of event firings. In the continuous stochastic model this will
be the approximate cumulative intensity of each event.}

\item{haz}{a list of hazard functions}

\item{dt}{time-step for Euler-Maruyama method used to solve the SDE system}

\item{maxhaz}{maximum allowable hazard}
}
\value{
function closure for use in \code{\link{sim_trajectory_R}} or \code{\link{sim_trajectory_CSV}}
}
\description{
Make a function closure to implement a chemical Langevin (continuous-state)
approximation for a SPN.
}
\details{
The chemical Langevin approximation is a numerical simulation of a Fokker-Planck
approximation to the Master equations (Kolmogorov Forwards Equations) governing
the stochastic model; the CLE approximation is a second-order approximation
that will get the correct mean and variance but higher order moments will be
incorrect.

The design of \code{step_CLE} is from: Wilkinson, D. J. (2011). Stochastic
modeling for systems biology. CRC press

Elements of the \code{N} list come from two places: The stoichiometry matrix
(\code{S}) is generated in \code{\link{spn_S}} and the hazards (\code{h}) come
from \code{\link{spn_hazards}}.

For other samplers, see: \code{\link{step_PTS}}, \code{\link{step_DM}}, \code{\link{step_ODE}}
}
