# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' sort vector y by values in vector x
#' 
#' @param y numeric vector
#' @param x numeric vector
#' @keywords internal
#' @return numeric vector
xysort <- function(y, x) {
    .Call(`_MD2sample_xysort`, y, x)
}

#' equivalent to R command order
#' 
#' @param x numeric vector
#' @keywords internal
#' @return integer vector
Order <- function(x) {
    .Call(`_MD2sample_Order`, x)
}

#' equivalent to R command rank
#' 
#' @param x numeric vector
#' @keywords internal
#' @return integer vector
Rank <- function(x) {
    .Call(`_MD2sample_Rank`, x)
}

#' Find test statistics for continuous data
#' 
#' @param x A matrix.
#' @param y A matrix
#' @param TSextra list with some helper functions
#' @keywords internal
#' @return A numeric vector with test statistics
TS_cont <- function(x, y, TSextra) {
    .Call(`_MD2sample_TS_cont`, x, y, TSextra)
}

#' Find test statistics for discrete data
#' @param x a vector of integers.
#' @param y a vector of integers.
#' @param vx a vector of real.
#' @param vy a vector of real.
#' @param TSextra list with extra infos
#' @keywords internal
#' @return A numeric vector with test statistics
TS_disc <- function(x, y, vx, vy, TSextra) {
    .Call(`_MD2sample_TS_disc`, x, y, vx, vy, TSextra)
}

#' This function calculates the test statistics
#' @param  dta data set
#' @param  TS routine
#' @param  typeTS format of TS
#' @param  TSextra list passed to TS function
#' @keywords internal
#' @return A vector of numbers
calcTS <- function(dta, TS, typeTS, TSextra) {
    .Call(`_MD2sample_calcTS`, dta, TS, typeTS, TSextra)
}

#' find pairwise Euclidean distances
#' 
#' @param dta A list of matrices
#' @keywords internal
#' @return A  matrix
find_dist <- function(dta) {
    .Call(`_MD2sample_find_dist`, dta)
}

#' simulate new data
#' @param dta data set
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_sim_data <- function(dta, TSextra) {
    .Call(`_MD2sample_gen_sim_data`, dta, TSextra)
}

getI <- function(p) {
    .Call(`_MD2sample_getI`, p)
}

#' simulate continuous data
#' @param x first data set
#' @param y second data set
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_cont <- function(x, y, TSextra) {
    .Call(`_MD2sample_gen_cont`, x, y, TSextra)
}

#' simulate new discrete data
#' @param x first data set, counts
#' @param y second data set, counts
#' @param vals_x values of discrete random variable x
#' @param vals_y values of discrete random variable y
#' @param TSextra extra stuff
#' @keywords internal
#' @return A list of permuted vectors
gen_disc <- function(x, y, vals_x, vals_y, TSextra) {
    .Call(`_MD2sample_gen_disc`, x, y, vals_x, vals_y, TSextra)
}

#' Finds the empirical distribution function
#' @param dta a matrix of data points
#' @param pts a matrix of evaluation points
#' @keywords internal
#' @return a numeric vector
mdecdf <- function(dta, pts) {
    .Call(`_MD2sample_mdecdf`, dta, pts)
}

#' Find the power of various continuous tests via simutation or permutation.
#' 
#' @param rxy a function that generates x and y data.
#' @param xparam  arguments for r1.
#' @param yparam  arguments for r2.
#' @param TS routine to calculate test statistics for non-chi-square tests
#' @param typeTS indicator for type of test statistics
#' @param TSextra additional info passed to TS, if necessary
#' @param B =1000 number of simulation runs
#' @keywords internal
#' @return A list values of test statistics
powerC <- function(rxy, xparam, yparam, TS, typeTS, TSextra, B = 1000L) {
    .Call(`_MD2sample_powerC`, rxy, xparam, yparam, TS, typeTS, TSextra, B)
}

#' run tests using either simulation or permutation.
#' 
#' @param dta a list with the data
#' @param TS routine to calculate test statistics for non-chi-square tests 
#' @param typeTS type of a test statistic
#' @param TSextra additional info passed to TS, if necessary
#' @param B =5000, number of simulation runs.
#' @keywords internal
#' @return A list with test statistics and p values
testC <- function(dta, TS, typeTS, TSextra, B = 5000L) {
    .Call(`_MD2sample_testC`, dta, TS, typeTS, TSextra, B)
}

#' transform data to interval (0,1).
#' 
#' @param dta a list.
#' @keywords internal
#' @return a list 
transform01 <- function(dta) {
    .Call(`_MD2sample_transform01`, dta)
}

