% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-PlottingModels.R
\name{plot_lincombs}
\alias{plot_lincombs}
\title{Plot Linear Combinations of Age-Period-Cohort Effects by Strata}
\usage{
plot_lincombs(
  inla_fit,
  apc_model,
  data,
  strata_col,
  reference_level,
  family = NULL,
  age_ind = "age",
  period_ind = "period",
  cohort_ind = "cohort",
  age_title = NULL,
  period_title = NULL,
  cohort_title = NULL,
  y_lab = NULL,
  age_vals = NULL,
  period_vals = NULL,
  cohort_vals = NULL,
  age_breaks = NULL,
  age_limits = NULL,
  period_breaks = NULL,
  period_limits = NULL,
  cohort_breaks = NULL,
  cohort_limits = NULL,
  PDF_export = FALSE
)
}
\arguments{
\item{inla_fit}{An object returned by the \code{inla()}-function, containing
the data frame \code{summary.lincomb.derived}, which holds the posterior summaries of the
cross strata contrasts from the MAPC model.
This function assumes that the rownames of the linear combinations are of the specific format produced by \code{\link{generate_apc_lincombs}}.}

\item{apc_model}{Character string indicating the configuration of shared vs. stratum-specific time effects in the model.}

\item{data}{The data frame used to fit \code{inla_fit}, containing columns
for age, period, cohort, and the stratification variable.}

\item{strata_col}{Character name of the factor column in \code{data} defining strata.}

\item{reference_level}{Character value of \code{strata_col} to use as the reference.}

\item{family}{Optional character; if \code{NULL}, \code{y_lab} defaults to
\code{"Mean differences"}.  If \code{"gaussian"}, same; if \code{"poisson"},
\code{"Log mean ratio"}; if \code{"binomial"}, \code{"Log odds ratio"}.}

\item{age_ind}{Character name of the age variable in \code{data} (default \code{"age"}).}

\item{period_ind}{Character name of the period variable in \code{data} (default \code{"period"}).}

\item{cohort_ind}{Character name of the cohort variable in \code{data} (default \code{"cohort"}).}

\item{age_title}{Optional plot title for the age effect.}

\item{period_title}{Optional plot title for the period effect.}

\item{cohort_title}{Optional plot title for the cohort effect.}

\item{y_lab}{Optional y-axis label; if \code{NULL}, set according to \code{family}.}

\item{age_vals}{Optional numeric vector of x-values for age; defaults to
\code{min(data\$age):max(data\$age)}.}

\item{period_vals}{Optional numeric vector of x-values for period; defaults to
\code{min(data\$period):max(data\$period)}.}

\item{cohort_vals}{Optional numeric vector of x-values for cohort; defaults to
\code{min(data\$cohort):max(data\$cohort)}.}

\item{age_breaks}{Optional vector of breaks for the age plot x-axis.}

\item{age_limits}{Optional numeric vector of length 2 giving x-axis limits for age.}

\item{period_breaks}{Optional vector of breaks for the period plot x-axis.}

\item{period_limits}{Optional numeric vector of length 2 giving x-axis limits for period.}

\item{cohort_breaks}{Optional vector of breaks for the cohort plot x-axis.}

\item{cohort_limits}{Optional numeric vector of length 2 giving x-axis limits for cohort.}

\item{PDF_export}{Logical; if \code{TRUE}, use larger font sizes/layout for PDF output.}
}
\value{
A named list of \code{ggplot} objects.  Elements are
\code{"age"}, \code{"period"}, and/or \code{"cohort"} depending on \code{apc_model}.
}
\description{
Generates ggplot2 line plots of estimated linear combinations
for age, period, and/or cohort effects from an INLA fit, stratified by a factor.
Returns a named list of ggplot objects for each requested effect.
}
\examples{
if (requireNamespace("INLA", quietly = TRUE)) {
  # Load toy dataset
  data("toy_data")

  # Filter away unobserved cohorts (see plot_missing_data() function):
  require(dplyr)
  toy_data.f <- toy_data \%>\% filter(sex == "female") \%>\% subset(cohort > 1931)

  # Load precomputed 'mapc' object
  apC_fit.f <- readRDS(system.file("extdata", "quickstart-apC_fit_f.rds", package = "MAPCtools"))

  # Extract INLA object:
  apC_fit.inla <- apC_fit.f$model_fit
  apC_plots <- plot_lincombs(
    inla_fit    = apC_fit.inla,
    apc_model   = "apC",
    data        = toy_data.f,
    strata_col  = "education",
    reference_level = "1",
    family      = "poisson",

  )
  # Display the age effect plot
  print(apC_plots$age)
  # Display the period effect plot
  print(apC_plots$period)
}

}
