% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_counts_1D}
\alias{plot_counts_1D}
\title{Plot counts of observations across a single variable, optionally stratified}
\usage{
plot_counts_1D(
  data,
  x,
  stratify_by = NULL,
  for_each = NULL,
  title = "Observation counts",
  subtitle = NULL,
  legend_title = NULL,
  x_lab = NULL,
  y_lab = NULL,
  viridis_color_option = "D"
)
}
\arguments{
\item{data}{Data frame containing all input variables.}

\item{x}{Variable in \code{data} whose values define the x-axis for counts.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, counts are computed for each combination of \code{x} and
\code{stratify_by}, and separate lines are drawn per level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable. If supplied,
separate plot windows are created per level of \code{for_each}.}

\item{title}{(Optional) Plot title; defaults to \code{"Observation counts"}.}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL} if for \code{for_each} is \code{NULL},
defaults to \code{<name of for_each>: <level of for_each>} for each plot window if \code{for_each} is supplied.}

\item{legend_title}{(Optional) Legend title; defaults to name of \code{stratify_var} if it is supplied.}

\item{x_lab}{(Optional) Label for the x-axis; defaults to the name of \code{x}.}

\item{y_lab}{(Optional) Label for the y-axis; defaults to the name of \code{y}.}

\item{viridis_color_option}{(Optional) Option for color gradient; defaults to "D".
Options are "A", "B", "C", "D", E", "F", "G", "H".
See \pkg{viridis} for information, or experiment yourself.}
}
\value{
A \link[ggplot2]{ggplot} object displaying counts across the variable supplied in \code{x},
optionally stratified by \code{stratify_by}. If \code{for_each} is supplied, separate plots are created  in separate windows for each level.
Visuals can be modified with \pkg{ggplot2}.
}
\description{
Computes the number of observations at each value of a specified variable and
creates a line plot of these counts using \pkg{ggplot2}. If a stratification variable
is provided, counts are calculated per strata and plotted as separate colored lines.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Counts by age
plot_counts_1D(toy_data, x = age)
# Counts by age, stratified by education level
plot_counts_1D(toy_data, x = age,
               stratify_by = education)
# Count by age, stratified by education level, for each sex
plot_counts_1D(toy_data, x = age,
               stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_counts_2D}}, \code{\link{plot_binned_counts}},
\code{\link{plot_counts_with_mean}}, \code{\link[ggplot2]{ggplot}}
}
