% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_PMTLinearity.R
\name{correct_PMTLinearity}
\alias{correct_PMTLinearity}
\title{Linearity Correction for Photomultiplier tubes (PMT)}
\usage{
correct_PMTLinearity(object, PMT_pulse_pair_resolution = NULL)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} \linkS4class{RLum.Data.Curve} (\strong{required}):
object with records to correct; can be a \link{list} of such objects}

\item{PMT_pulse_pair_resolution}{\link{numeric} (\emph{with default}): pulse-pair resolution
in ns. Values can be found on the PMT datasheets. If \code{NULL} nothing is done.}
}
\value{
Returns the same type of object type as \code{object}.
}
\description{
Correct linearity of PMT counts to avoid saturation effects, depending
on pulse-pair-resolution of individual PMTs.
}
\details{
We correct for count linearity using a well-known formula that can be
found for example in the Hamamatsu Photomultiplier handbook
(Hamamatsu Photonics K.K., 2017):

\deqn{N = \frac{M}{1 - M*t}}

where \eqn{N} (in s\eqn{^{-1}}) is the true count rate, \eqn{M} (in s\eqn{^{-1}}) the measured count rate,
and \eqn{t} (in s) the pulse pair resolution.
}
\note{
This function is an adaptation of core from the R package
'OSLdecomposition'.
}
\examples{
o <- set_RLum("RLum.Data.Curve")
correct_PMTLinearity(o, PMT_pulse_pair_resolution = 10)

} 

\section{How to cite}{
Kreutzer, S., Mittelstrass, D., 2025. correct_PMTLinearity(): Linearity Correction for Photomultiplier tubes (PMT). In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\references{
Hamamatsu Photonics K.K., 2017. Photomultiplier Tubes: Basics and Applications, 4th edition. ed. Hamamatsu.

Mittelstraß, D., Kreutzer, S., Schmidt, C., 2022. OSLdecomposition: Signal
component analysis for optically stimulated luminescence. \doi{10.32614/CRAN.package.OSLdecomposition}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
Dirk Mittelstrass, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{manip}
