% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-BIC.R
\name{PLR.BIC}
\alias{PLR.BIC}
\title{Determines the regularization parameter (lambda) in a PLR via optimization of an information criterion.}
\usage{
PLR.BIC(y, x, theta, weights = NULL, IC = c("BIC", "AIC"))
}
\arguments{
\item{y}{a vector of responses}

\item{x}{a matrix of explanatory variables}

\item{theta}{matrix gathering the path of estimated parameter vectors. Each row corresponds to a given covariate. Each column corresponds to a given value of lambda}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{IC}{indicates which information criterion is used. Possibles values are "BIC" (default) or "AIC".}
}
\value{
A list with two components
\describe{
   \item{\code{val}}{vector indicating the value attained by the information criterion for each value of lambda.}
   \item{\code{best}}{index of the value of lambda where the optimum is attained.}
}
}
\description{
\code{PLR.BIC} takes as input a matrix of estimated parameter vectors, where each row corresponds to a covariate and each column corresponds to a value of lambda,
and returns the index of the optimal column by optimizing an information criterion. By default the BIC is used.
}
\section{References}{

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024). A penalised bootstrap estimation procedure for the explained Gini coefficient. \emph{Electronic Journal of Statistics 18(1) 247-300}.
}

\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Lorenz.FABS}}, \code{\link{Lorenz.SCADFABS}}
}
\keyword{internal}
