% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions.R
\name{zero_inflate}
\alias{zero_inflate}
\title{Zero-inflated density constructer}
\usage{
zero_inflate(dist, discrete = NULL)
}
\arguments{
\item{dist}{either a probability density function or a probability mass function}

\item{discrete}{logical; if \code{TRUE}, the density for \code{x = 0} will be \code{zeroprob + (1-zeroprob) * dist(0, ...)}. Otherwise it will just be \code{zeroprob}.
In standard cases, this will be determined automatically. For non-standard cases, set this to \code{TRUE} or \code{FALSE} depending on the type of \code{dist}. See details.}
}
\value{
zero-inflated density function with first argument \code{x}, second argument \code{zeroprob}, and additional arguments \code{...} that will be passed to \code{dist}.
}
\description{
Constructs a zero-inflated density function from a given probability density function
}
\details{
The definition of zero-inflation is different for discrete and continuous distributions.
For discrete distributions with p.m.f. \eqn{f} and zero-inflation probability \eqn{p}, we have
\deqn{\Pr(X = 0) = p + (1 - p) \cdot f(0),} and
\deqn{\Pr(X = x) = (1 - p) \cdot f(x), \quad x > 0.}

For continuous distributions with p.d.f. \eqn{f}, we have
\deqn{f_{\text{zinfl}}(x) = p \cdot \delta_0(x) + (1 - p) \cdot f(x),}
where \eqn{\delta_0} is the Dirac delta function at zero.
}
\examples{
dzinorm <- zero_inflate(dnorm)
dzinorm(c(NA, 0, 2), 0.5, mean = 1, sd = 1)

zipois <- zero_inflate(dpois)
zipois(c(NA, 0, 1), 0.5, 1)
}
