% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksic_search.R
\name{ksic_search}
\alias{ksic_search}
\title{Search KSIC by Keyword}
\usage{
ksic_search(keyword, C = NULL, ignore.case = TRUE, digit = NULL)
}
\arguments{
\item{keyword}{character. keyword to search for.}

\item{C}{integer. The KSIC revision. If NULL, \code{getOption("ksic.C", 11)} is used.}

\item{ignore.case}{logical. If \code{TRUE}, the case is ignored during search. Default is \code{TRUE}.}

\item{digit}{integer. Can be a vector of (1-5). If NULL, all digits are searched.}
}
\value{
A data.frame of matching KSIC codes and names, or \code{NULL} if no match is found.
}
\description{
Searches for KSIC codes by a keyword in Korean or English classification names.
If searching with a Korean keyword, the English name (\code{eng_nm}) column is excluded from the result.
}
\examples{

ksic_search("software", C = 10, ignore.case = FALSE, digit = 5)

ksic_search("data|database")
}
