% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksic_group.R
\name{ksic_group}
\alias{ksic_group}
\title{Extract Parent KSIC Codes}
\usage{
ksic_group(ksic, digit = 1, C = NULL, name = FALSE)
}
\arguments{
\item{ksic}{character.
A vector of KSIC codes to find parent codes for.}

\item{digit}{integer.
The digit of the parent classification to extract (1-5). Default is 1.}

\item{C}{integer.
The KSIC revision (9, 10, or 11). If NULL, \code{getOption("ksic.C", 11)} is used.}

\item{name}{logical.
If \code{TRUE}, returns names; if \code{FALSE}, returns codes. Default is \code{FALSE}.}
}
\value{
A character vector of the same length as the input vector, containing parent codes or names. Returns \code{NA} if a parent code does not exist.
}
\description{
Extracts the parent classification codes corresponding to the input KSIC codes. It can handle a vector containing codes with different numbers of digits.
}
\examples{
ksic_group(c("31311", "4631", "25", "A"), digit = 2, name = TRUE)

ksic_group("26222", digit = 4)
}
