% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBPC.R
\name{plotBPC}
\alias{plotBPC}
\title{Plot base peak chromatograms for multiple high resolution masses in multiple samples.}
\usage{
plotBPC(
  bpc = NULL,
  mfrow = NULL,
  skip_plots = NULL,
  ylim = NULL,
  col = NULL,
  ids = NULL,
  type = "both",
  ann = c("mdev", "mz", "none")
)
}
\arguments{
\item{bpc}{A bpc object (list of intensity matrices, rt x mz, including several attributes as attached by \link{getMultipleBPC}).}

\item{mfrow}{Specify mfrow explicitly (is optimized internally if NULL to cover n=length(bpc)).}

\item{skip_plots}{Allows to block certain subplots in the mfrow matrix to better align replicates.}

\item{ylim}{Can be specified specifically, will be adjusted to overall min/max otherwise.}

\item{col}{Specific color vector for masses may be provided.}

\item{ids}{Specific plot ids may be explicitly provided.}

\item{type}{Switch between co-plot of BPC and Spectrum ("both") or BPC alone ("bpc").}

\item{ann}{Select value to annotate peaks in spectrum. Usually the mass deviation from the expected value in mDa.}
}
\value{
A plot to the graphics device and NULL as invisible.
}
\description{
\code{plotBPC} will plot for each item of a list of result-objects
    from \link{getMultipleBPC} the BPC traces and the spectrum at the scan
    where the summed intensity of all ions is max.
}
\details{
\code{plotBPC} allows to get a quick overview of similar information
    from all samples of an experimental set. As it uses `mfrow` to arrange samples
    its output can not be used as subplot in other figures.
}
\examples{
# load example raw data
bpc <- HiResTEC::res_list[[1]][["bpc"]][c(1:2, 13:14)]
plotBPC(bpc = bpc)
plotBPC(bpc = bpc, ann="mz", ids=LETTERS[1:4], mfrow=c(3,2), skip_plots=c(2,3))

}
