% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_MergeObs.R
\name{MergeObs}
\alias{MergeObs}
\title{Merge two HYPE observation data frames}
\usage{
MergeObs(x, y)
}
\arguments{
\item{x, y}{Data frames containing observation timeseries data. Typically imported using \code{\link{ReadObs}}.}
}
\value{
\code{MergeObs} returns a data frame with merged Obs data.
}
\description{
Function to merge two HYPE observation data frames, with handling of overlapping time periods and time periods gaps
as well as merging of common columns.
}
\details{
\code{MergeObs} handles time steps of different lengths (e.g. daily, hourly), but requires identical time
step lengths from both inputs data frames.

In case of common columns (identical date and SUBID combinations in \code{x} and \code{y}),
values from columns in \code{x} will take precedence, and values from \code{y} will only be added if
\code{x} values are missing.
}
\examples{
# Import dummy data, add new observations to second Obs table, and merge
te1 <- ReadObs(filename = system.file("demo_model", "Tobs.txt", package = "HYPEtools"))
te2 <- ReadObs(filename = system.file("demo_model", "Tobs.txt", package = "HYPEtools"))
te2$X0000[1:365] <- runif(n = 365, -20, 25)
MergeObs(x = te1, y = te2)

}
