% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_oracle_infer.R
\name{get_oracle_bias_var_adj_db}
\alias{get_oracle_bias_var_adj_db}
\title{Estimate the oracle bias, the oracle variance of the unadjusted estimator, the adjusted estimator by Lei’s (2020) and the debiased estimator tau_db by Lu et al.(2023).}
\usage{
get_oracle_bias_var_adj_db(X, Y1, n1 = NULL)
}
\arguments{
\item{X}{The n by p covariates matrix.}

\item{Y1}{Vector of n dimensional potential response Y(1).}

\item{n1}{The number of subjects in the treatment group.}
}
\value{
A list of the oracle bias and variance of .
\item{bias_adj}{The oracle bias of the adjusted estimator tau_adj we proposed.}
\item{variance_unadj}{The oracle variance of the unadjusted estimator.}
\item{variance_adj_lin}{The oracle variance of Lei’s (2020) debiased estimator with linear working model.}
\item{variance_db}{The oracle variance of the debiased estimator tau_db by Lu et al.(2023).}
}
\description{
Estimate the oracle bias, the oracle variance of the unadjusted estimator, the adjusted estimator by Lei’s (2020) and the debiased estimator tau_db by Lu et al.(2023).
}
\examples{
NULL
}
\references{
Lihua Lei, Peng Ding. Regression adjustment in completely randomized experiments with a diverging number of covariates. Biometrika, 815–828, 2020.

Xin Lu, Fan Yang, and Yuhao Wang. Debiased regression adjustment in completely randomized experiments with moderately high-dimensional covariates. arXiv preprint arXiv:2309.02073, 2023.
}
