% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmda.init.R
\name{hmda.init}
\alias{hmda.init}
\title{Initialize or Restart H2O Cluster for HMDA
       Analysis}
\usage{
hmda.init(
  cpu = -1,
  ram = NULL,
  java = NULL,
  ip = "localhost",
  port = 54321,
  verbatim = FALSE,
  restart = TRUE,
  shutdown = FALSE,
  ignore_config = TRUE,
  bind_to_localhost = FALSE,
  ...
)
}
\arguments{
\item{cpu}{integer. The number of CPU threads to use.
-1 indicates all available threads. Default is -1.}

\item{ram}{numeric. Minimum memory (in GB) for the cluster.
If NULL, all available memory is used.}

\item{java}{character. Path to the Java JDK. If provided, sets
JAVA_HOME accordingly.}

\item{ip}{character. The IP address for the H2O server.
Default is "localhost".}

\item{port}{integer. The port for the H2O server.
Default is 54321.}

\item{verbatim}{logical. If TRUE, prints detailed cluster info.
Default is FALSE.}

\item{restart}{logical. if TRUE, the server is erased and restarted}

\item{shutdown}{logical. if TRUE, the server is closed}

\item{ignore_config}{logical. If TRUE, ignores any existing H2O
configuration. Default is TRUE.}

\item{bind_to_localhost}{logical. If TRUE, restricts access to the
cluster to the local machine. Default is FALSE.}

\item{...}{Additional arguments passed to h2o.init().}
}
\value{
An object representing the connection to the H2O
        cluster.
}
\description{
Initializes or restarts an H2O cluster configured for
       Holistic Multimodel Domain Analysis. It sets up the cluster
       with specified CPU threads, memory, and connection settings.
       It first checks for an existing cluster, shuts it down if
       found, and then repeatedly attempts to establish a new
       connection, retrying up to 10 times if necessary.
}
\details{
The function sets JAVA_HOME if a Java path is provided.
        It checks for an existing cluster via h2o.clusterInfo().
        If found, the cluster is shut down and the function waits
        5 seconds. It then attempts to initialize a new cluster using
        h2o.init() with the specified settings. On failure, it retries
        every 3 seconds, up to 10 attempts. If all attempts fail, an
        error is thrown.
}
\examples{
\dontrun{
  # Example 1: Initialize the H2O cluster with default settings.
  library(hmda)
  hmda.init()

  # Example 2: Initialize with specific settings such as Java path.
  conn <- hmda.init(
      cpu = 4,
      ram = 8,
      java = "/path/to/java",     #e.g., "C:/Program Files/Java/jdk1.8.0_241"
      ip = "localhost",
      port = 54321,
      verbatim = TRUE
  )

  # check the status of the h2o connection
  h2o::h2o.clusterInfo(conn) #you can use h2o functions to interact with the server
}

}
\author{
E. F. Haghish
}
