% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifMatch.R
\name{validateMotif}
\alias{validateMotif}
\title{Determine if a Motif is Properly Formatted}
\usage{
validateMotif(motif, alignType)
}
\arguments{
\item{motif}{A character string identifying a sequence variant motif in the following format: Locus*#$~#$~#$, where ## identifies a variant position, and $ identifies the sequence variant. Both nucleotide and peptide motifs can be provided, and any number of variants can be specified.}

\item{alignType}{A character string identifying the type of alignment being searched. Allowed values are "codon","gen", nuc" and "prot". Only one 'alignType' value is allowed.}
}
\value{
If the motif is valid, TRUE is returned. If the locus or body of the motif is invalid, FALSE is returned along with a brief message.
}
\description{
Evaluates a motif to determine if the locus is valid and variants are valid.
}
\examples{
validateMotif("A*-21M~2P","prot")
validateMotif("A*196G~301A~3046T","gen")

}
