% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{multiUpdateGL}
\alias{multiUpdateGL}
\title{Update a Vector of GL String Code Data to a Desired IPD-IMGT/HLA Database Version}
\usage{
multiUpdateGL(GLSCs, to, expand = FALSE, verbose = FALSE)
}
\arguments{
\item{GLSCs}{A vector of GL String Codes.}

\item{to}{A character string identifying the IPD-IMGT/HLA Database release version to translate 'GLSCs' to. Values can range from version 1.05.0 to the loaded version of the alleleListHistory object.}

\item{expand}{A logical that indicates if the lowest-numbered truncated allele names that match truncated allele names in 'GLSCs' should be returned (expand = FALSE), or if a slash-delimited string of all matching full-length allele names should be returned (expand = TRUE). The default value is FALSE.}

\item{verbose}{A logical that indicates if messages regarding the update process should be sent to the console (TRUE) or not (FALSE). The default value is FALSE.}
}
\value{
A version GLSCs (in a data frame) updated to the desired version. NA values are returned in place of alleles that are not present in 'to'.
}
\description{
Updates a column from a data frame in GL String Code format to a desired reference database version.
}
\examples{
multiUpdateGLs <- multiUpdateGL(GLSC.ex$GL.String.Code[1:50],"2.25.0")
multiUpdateGLs <- multiUpdateGL(GLSC.ex$GL.String.Code[1:50],"3.58.0")

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126

Mack et al. HLA 2023;102(4):501-507 https://doi.org/10.1111/tan.15145
}
