% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob.hits.R
\name{prob.hits}
\alias{prob.hits}
\title{Find Probability of Locus Hit}
\usage{
prob.hits(hit.cnt, chr.size = NULL)
}
\arguments{
\item{hit.cnt}{A list returned by the \code{count.hits()} function, containing the number of subjects and hits affecting each locus by lesion type.}

\item{chr.size}{A \code{data.frame} containing chromosome sizes for all 22 autosomes and the X and Y chromosomes. It must include two columns: \code{"chrom"} for chromosome number, and \code{"size"} for chromosome lengths in base pairs.}
}
\value{
A list with the following components:
\item{gene.hits}{A \code{data.frame} containing GRIN statistical results. Includes gene annotations, the number of subjects and hits by lesion type, and the computed p-values and FDR-adjusted q-values for lesion enrichment across one or more lesion types.}
\item{lsn.data}{Original input lesion data.}
\item{gene.data}{Original input gene annotation data.}
\item{gene.lsn.data}{A \code{data.frame} in which each row corresponds to a gene overlapped by a specific lesion. Includes columns for Ensembl gene ID (\code{gene}) and patient/sample ID (\code{ID}).}
\item{chr.size}{Chromosome size information used in the computation.}
\item{gene.index}{A \code{data.frame} indexing rows in \code{gene.lsn.data} corresponding to each chromosome.}
\item{lsn.index}{A \code{data.frame} indexing rows in \code{gene.lsn.data} corresponding to each lesion.}
}
\description{
Computes the probability that each genomic locus (e.g., gene or regulatory region) is affected by one or more types of genomic lesions. This function estimates statistical significance for lesion enrichment using a convolution of independent but non-identical Bernoulli distributions.
}
\details{
This function estimates a p-value for each locus based on the probability of observing the observed number of lesions (or more) by chance, under a model where lesion events are treated as independent Bernoulli trials.

For each lesion type, the model considers heterogeneity in lesion probability across loci based on their genomic context (e.g., locus size, chromosome size). These probabilities are then combined using a convolution of Bernoulli distributions to estimate the likelihood of observing the actual hit counts.

In addition, the function calculates:
\itemize{
\item \strong{FDR-adjusted q-values} using the method of Pounds and Cheng (2006), which estimates the proportion of true null hypotheses.
\item \strong{p- and q-values for multi-lesion constellation hits}, i.e., the probability that a locus is affected by one (\code{p1}), two (\code{p2}), or more types of lesions simultaneously.
}
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# 1) Prepare gene and lesion data:
prep.gene.lsn <- prep.gene.lsn.data(lesion_data, hg38_gene_annotation)

# 2) Identify overlapping gene-lesion events:
gene.lsn.overlap <- find.gene.lsn.overlaps(prep.gene.lsn)

# 3) Count number of subjects and lesions affecting each gene:
count.subj.hits <- count.hits(gene.lsn.overlap)

# 4) Compute p- and q-values for lesion enrichment per gene:
hits.prob <- prob.hits(count.subj.hits, hg38_chrom_size)
}
\references{
Pounds, S. et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{prep.gene.lsn.data}}, \code{\link{find.gene.lsn.overlaps}}, \code{\link{count.hits}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
