% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.binary.lsn.mtx.R
\name{prep.binary.lsn.mtx}
\alias{prep.binary.lsn.mtx}
\title{Prepare Binary Lesion Matrix}
\usage{
prep.binary.lsn.mtx(ov.data, min.ngrp = 0)
}
\arguments{
\item{ov.data}{A list of six \code{data.frame} objects representing the output from the \code{\link{find.gene.lsn.overlaps}} function.}

\item{min.ngrp}{Optional integer specifying the minimum number of patients that must be affected by a given gene-lesion combination to be retained in the output matrix. The default is \code{0}, which includes all combinations affecting at least one patient.}
}
\value{
A binary matrix (as a \code{data.frame}) where:
\itemize{
\item Rows correspond to gene-lesion combinations (\code{gene.ID_lesion.type}).
\item Columns correspond to patient IDs.
\item Entries are binary: \code{1} if the patient is affected by such a specific type of  lesion in that gene, \code{0} otherwise.
}
}
\description{
Constructs a binary matrix representing the presence or absence of specific lesion types affecting individual genes across patients. Each row corresponds to a gene-lesion type combination, and each column corresponds to a patient.
}
\details{
The function processes the overlap results from \code{\link{find.gene.lsn.overlaps}} and constructs a binary matrix with dimensions: (gene and lesion type) by patient.

Each row is labeled using the format \code{<gene.ID>_<lesion.type>} (e.g., \code{ENSG00000118513_gain} for a gain affecting the MYB gene). For each gene-lesion combination, a patient receives a value of \code{1} if affected by that specific lesion type in the corresponding gene, and \code{0} otherwise.

Rows representing rare lesions (i.e., affecting fewer patients than \code{min.ngrp}) are excluded from the final matrix if \code{min.ngrp > 0}.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)

# 1) Prepare gene-lesion input data:
prep.gene.lsn <- prep.gene.lsn.data(lesion_data,
                                    hg38_gene_annotation)

# 2) Identify gene-lesion overlaps:
gene.lsn.overlap <- find.gene.lsn.overlaps(prep.gene.lsn)

# 3) Create binary lesion matrix including only lesion-gene pairs affecting >= 5 patients:
lsn.binary.mtx <- prep.binary.lsn.mtx(gene.lsn.overlap, min.ngrp = 5)
}
\references{
Pounds, S., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{prep.gene.lsn.data}}, \code{\link{find.gene.lsn.overlaps}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
